<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-03-08 08:37
 */
interface ReturnsellbillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Returnsellbillcurr 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param returnsellbillcurr primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Returnsellbillcurr returnsellbillcurr
 	 */
	public function insert($returnsellbillcurr);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Returnsellbillcurr returnsellbillcurr
 	 */
	public function update($returnsellbillcurr);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReturnsellbillid($value);

	public function queryByConversionFactor($value);

	public function queryByReturnsellbilldiscountC($value);

	public function queryByReturnsellbilltotalbillC($value);

	public function queryByReturnsellbillaftertotalbillC($value);

	public function queryByReturnsellbilltotalpayedC($value);

	public function queryByReturnsellbillfinalbillC($value);

	public function queryByReturnsellbildirectpaymentC($value);

	public function queryByTaxC($value);

	public function queryByCashPayedC($value);

	public function queryByVisaPayedC($value);

	public function queryByExtraDiscountValC($value);

	public function queryByTaxOfDiscountValC($value);

	public function queryBySaveConversionFactor($value);


	public function deleteByReturnsellbillid($value);

	public function deleteByConversionFactor($value);

	public function deleteByReturnsellbilldiscountC($value);

	public function deleteByReturnsellbilltotalbillC($value);

	public function deleteByReturnsellbillaftertotalbillC($value);

	public function deleteByReturnsellbilltotalpayedC($value);

	public function deleteByReturnsellbillfinalbillC($value);

	public function deleteByReturnsellbildirectpaymentC($value);

	public function deleteByTaxC($value);

	public function deleteByCashPayedC($value);

	public function deleteByVisaPayedC($value);

	public function deleteByExtraDiscountValC($value);

	public function deleteByTaxOfDiscountValC($value);

	public function deleteBySaveConversionFactor($value);


}
?>